//	CRenameTextEdit.h

#ifndef _H_CRenameTextEdit
#define _H_CRenameTextEdit

#include "MemUtils.h"
#include "CRenameTextEdit.h"

typedef enum {
	RTE_Command_NONE, 
	
	RTE_Command_CUT, 
	RTE_Command_COPY, 
	RTE_Command_PASTE, 
	RTE_Command_CLEAR, 
	RTE_Command_SELECT_ALL, 
	
	RTE_Command_NUMTYPES
} RTE_CommandType;

typedef		void	(*FinishRenameTextEditCB)(void *data);
typedef		void	(*CancelRenameTextEditCB)(void *data);

typedef		void	(*DoKeyDown_CB)(
	char			theChar, 
	Byte			keyCodeByte, 
	EventRecord		*macEvent, 
	void			*refcon);

//	I think this is a mac limitation?
#define	RTE_ABSOLUTE_MAX	32767

class	CRenameTextEdit;
typedef char **TextHandle;

CRenameTextEdit		*GetNewRenameTextEdit(
	const	char				*text, 
	Rect						*viewRect, 
	ulong						maxBytes, 
	FinishRenameTextEditCB		finishRenameCB, 
	void						*finishRenameData, 
	long						refconL);

/*****************************************************************/

class	CRenameTextEdit {

	public:	Boolean	IRenameTextEdit(
		const char					*text, 
		Rect						*viewRect, 
		ulong						maxBytes, 
		FinishRenameTextEditCB		finishRenameCB, 
		void						*finishRenameData, 
		long						refconL);
	
	virtual	void	Dispose(void);
	virtual	void	Cancel(void);
	virtual	void	Finish(void);
	
	virtual	void	SetCancelCallback(
		CancelRenameTextEditCB	cancelCB, 
		void					*cancelData);

	virtual	void	SetKeyDownCallback(
		DoKeyDown_CB	keyDownCallback,
		void			*keyDownRefcon);

	virtual	TextHandle	GetTextH(Boolean lockB = FALSE);

	virtual	void	GetTEStats(
		Rect		*view_rect0, 
		Rect		*dest_rect0, 
		ulong		*sel_start0, 
		ulong		*sel_end0, 
		ulong		*text_length0,
		ulong		*line_height0, 
		ulong		*n_lines0);

	virtual	Rect	GetViewRect(void);
	virtual	Rect	GetViewRectFrame(void);
	virtual	void	SetViewRect(Rect *viewRect);

	virtual	void	Resize(Rect *newRect);
	
	virtual	char	*GetText(char *text);
	virtual	void	SetText(char *text);
	virtual	void	Idle(void);
	
	virtual	long	TextLength(void);
	virtual	ulong	SelLength(void);
	virtual	void	DoKeyDown(char theChar, Byte keyCode, EventRecord *macEvent);
	virtual	void	InsertText(char *bufZ);

	virtual	Boolean	WillHandleCommand(long cmd, RTE_CommandType *te_cmd);
	virtual	void	DoCommand(RTE_CommandType cmd);
	virtual	Boolean	DoClick(Point thePoint, short modifierKeys, long when);
	
	virtual	void	Set_AllowReturn(Boolean allow_returnB);
	virtual	void	Draw(void);
	
	virtual	void	UpdateMenus(void);
	virtual	void	GetCBData(void **refconPV, long *refconL);
	
	CRenameTextEdit		*IsThisRename(void);

	static	CRenameTextEdit	*GetCurTextEdit(void);
	static	void			FinishRename(void);

	/************************************/
	TEHandle					i_te;
	ulong						i_maxBytes;

	FinishRenameTextEditCB		i_finishRenameCB;
	void						*i_finishRenameData;
	
	CancelRenameTextEditCB		i_cancelCB0;
	void						*i_cancelData0;

	DoKeyDown_CB				i_doKeyDownCB;
	void						*i_doKeyDownRefcon;
	
	Boolean						i_discardDBC2ndByte;
	long						i_refconL;

	//	CR does NOT end edit session, but is inserted into the text field
	Boolean						i_allow_returnB;	
	
	static CRenameTextEdit		*i_curTextEdit;
};


#endif